<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/nmfp1"
	xmlns:ns3="http://www.sec.gov/edgar/nmfp1common">
	
	<xsl:decimal-format name="percentage" digit="d"/>
	
	<!-- Item 1 templates -->
	<xsl:template name="Item1">
		<h3>General Information</h3>
		<table id="generalInfomration">
			<tr>
				<td class="label"><b>Item 1.</b> Report for [YYYY-MM-DD]:</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:reportDate)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item 2.</b> CIK Number of Registrant.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:cik)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item 3.</b> LEI of Registrant (if available) (See General Instructions E.)</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:registrantLEIId)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item 4.</b> EDGAR Series Identifier.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:seriesId)" />
					</div>
				</td>
			</tr>
			<tr  >
				<td class="label"><b>Item 5.</b> Total number of share classes in the series.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:totalShareClassesInSeries)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>Item 6.</b> Do you anticipate that this will be the fund's final filing on Form N-MFP? If Yes, answer Items 6.a - 6.c.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:finalFilingFlag) = 'Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:finalFilingFlag) = 'N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>				
			</tr>
			
			<xsl:if test="string(m1:generalInfo/m1:finalFilingFlag) = 'Y'">
				<tr>
					<td class="label"> a. Is the fund liquidating? </td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundLiquidatingFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundLiquidatingFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>
				<tr>
					<td class="label"> b. Is the fund merging with, or being acquired by, another fund? </td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundMrgOrAcqrdByOthrFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundMrgOrAcqrdByOthrFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>							
					</td>
				</tr>
				<xsl:if test="count(m1:generalInfo/m1:successorFund) &gt; 0">
					<tr>
						<td class="label">
							c. If applicable, identify the successor fund by CIK, 
							Securities Act file number, and EDGAR series identifier.
						</td>
					</tr>
					<xsl:if test="string(m1:generalInfo/m1:fundMrgOrAcqrdByOthrFlag) = 'Y'">
						<xsl:for-each select="m1:generalInfo/m1:successorFund">
							<tr>
								<td class="label"><blockquote>CIK of successor fund</blockquote></td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:cik" />
									</div>
								</td>
							</tr>
							<tr>	
								<td class="label">
									<blockquote>Securities Act file number of successor fund</blockquote>
								</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:fileNumber" />
									</div>
								</td>
							</tr>
							<tr>
								<td class="label">
									<blockquote>EDGAR series identifier of successor fund</blockquote>
								</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:seriesId" />
									</div>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label"><b>Item 7.</b> Has the fund acquired or merged with another fund since the last filing?</td>
				<td>								
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:fundAcqrdOrMrgdWthAnthrFlag)='Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:fundAcqrdOrMrgdWthAnthrFlag)='N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			<tr>
				<td class="label">If Yes, answer Item 7.a.</td>
				<td></td>
			</tr>
			<xsl:if test="string(m1:generalInfo/m1:fundAcqrdOrMrgdWthAnthrFlag) = 'Y'">
				<tr>
					<td class="label">
						a. Identify the acquired or merged fund by CIK, Securities Act file number, and EDGAR series identifier.
					</td>
					<td>
					</td>
				</tr>
				<xsl:for-each select="m1:generalInfo/m1:acquiredMergedFund">
					<tr>
						<td class="label">
							<blockquote>CIK of acquired/merged fund</blockquote>
						</td> 
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:cik" />
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Securities Act file number of acquired/merged fund
							</blockquote>
						</td> 
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:fileNumber" />
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								EDGAR series identifier of acquired/merged fund
							</blockquote>
						</td> 
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:seriesId" />
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
			<tr>
				<td class="label">
					<b>Item 8.</b> Provide the name, e-mail address, and telephone number of the person authorized to receive information and respond to questions about this Form N-MFP
				</td>
				<td>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Name</blockquote></td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:generalInfo/m1:contact2/m1:contactName)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Phone Number</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:contact2/m1:contactPhoneNumber)" />
					</div>
				</td>				
			</tr>
			<tr>
				<td class="label"><blockquote>Email Address</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="string(m1:generalInfo/m1:contact2/m1:contactEmailAddress)" />
					</div>
				</td>
			</tr>
		</table>

		<h3>Part A: Series-Level Information about the Fund</h3>
		<table>
			<tr>
				<td class="label"><b>Item A.1</b> Securities Act File Number.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:securitiesActFileNumber)" />
					</div>
				</td>
			</tr>
			<xsl:for-each select="m1:seriesLevelInfo/m1:adviser">
				<tr>
					<td class="label"><b>Item A.2</b> Investment Adviser</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="m1:adviserName" />
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label">a. SEC file number of investment adviser</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:adviserFileNumber" />
						</div>
					</td>
				</tr>
			</xsl:for-each>

			<xsl:if test="count(m1:seriesLevelInfo/m1:subAdviser) &gt; 0">
				<xsl:for-each select="m1:seriesLevelInfo/m1:subAdviser">
					<tr>
						<td class="label">
							<b>Item A.3</b> Sub-Adviser. If a fund has one or more sub-advisers, disclose the name of each sub-adviser.
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="m1:adviserName" />
							</div>								
						</td>
					</tr>
					<tr>
						<td class="label">a. SEC file number of sub-adviser</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:adviserFileNumber" />
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
			<tr>
				<td class="label"><b>Item A.4</b> Independent Public Accountant.</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:indpPubAccountant/m1:name)" />
					</div>					
				</td>
			</tr>
			<tr>
				<td class="label">a. City and state of independent public accountant.</td>
				<td></td>
			</tr>
			<tr>
				<td class="label"><blockquote>City of independent public accountant</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:indpPubAccountant/m1:city)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>State/Province/Country of independent public accountant</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
							select="string(m1:seriesLevelInfo/m1:indpPubAccountant/m1:stateCountry)" />
						</xsl:call-template>
					</div>
				</td>
			</tr>		
			<xsl:for-each select="m1:seriesLevelInfo/m1:administrator">
				<tr>
					<td class="label">
						<b>Item A.5</b> Administrator. If a fund has one or more administrators, disclose the name of each administrator.
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="m1:administratorName" />
						</div>
					</td>
				</tr>
			</xsl:for-each>	
			<xsl:for-each select="m1:seriesLevelInfo/m1:transferAgent">
				<tr>
					<td class="label"><b>Item A.6</b> Transfer Agent.</td>
					<td>
						<div class="fakeBox3">
							<xsl:if test="count(.) &gt; 0">
									<xsl:value-of select="m1:name" />
							</xsl:if>
						</div>
					</td>
				</tr>
				<xsl:if test="count(m1:cik) &gt; 0">
					<tr>
						<td class="label">a. CIK Number</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:cik" />
							</div>					
						</td>
					</tr>
					<tr>
						<td class="label">b. SEC file number of transfer agent.</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:fileNumber" />
							</div>					
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
			<tr>
				<td class="label">
					<b>Item A.7</b> Master-Feeder Funds. Is this a Feeder Fund? If Yes, answer Items A.7.a - 7.c.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:feederFundFlag)='Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:feederFundFlag)='N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			
			<tr>
				<td class="label">
					a. Identify the Master Fund by CIK or, if the fund does not have a CIK, by name.
				</td>
				<td></td>
			</tr>
			<xsl:if test="string(m1:seriesLevelInfo/m1:feederFundFlag) = 'Y'">
				<tr>
					<td class="label"><blockquote>CIK of the Master Fund</blockquote></td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="string(m1:seriesLevelInfo/m1:masterFeederFund/m1:cik)" />
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label"><blockquote>Name of the Master Fund</blockquote></td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="string(m1:seriesLevelInfo/m1:masterFeederFund/m1:name)" />
						</div>					
					</td>					
				</tr>
				<tr>
					<td class="label">b. Securities Act file number of the Master Fund.</td>
					<td>
						<div class="fakeBox2">	
							<xsl:value-of select="string(m1:seriesLevelInfo/m1:masterFeederFund/m1:fileNumber)" />
						</div>
					</td>
				</tr>
				<xsl:if test="count(m1:seriesLevelInfo/m1:masterFeederFund/m1:cik) &gt; 0">
					<tr>
						<td class="label">c. EDGAR series identifier of the Master Fund.</td>
						<td>
							<div class="fakeBox2">	
								<xsl:value-of select="m1:seriesLevelInfo/m1:masterFeederFund/m1:seriesId" />
							</div>	
						</td>
					</tr>
				</xsl:if>
			</xsl:if>		
			<tr>
				<td class="label">
					<b>Item A.8</b> Master-Feeder Funds. Is this a Master Fund? If Yes, answer Items A.8.a - 8.c.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:masterFundFlag)='Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:masterFundFlag)='N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			
			<xsl:if test="$masterFundFlagYesNo = 'Y'">
				<xsl:for-each select="m1:seriesLevelInfo/m1:feederFund">
					<tr>
						<td class="label">
							a. Identify all Feeder Funds by CIK or, if the fund does not have a CIK, by name.
						</td>
						<td>
						</td>
					</tr>
					<xsl:if test="count(m1:cik) &gt; 0">
						<tr>
							<td class="label"><blockquote>CIK of the Feeder Fund</blockquote></td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="m1:cik" />
								</div>
							</td>										
						</tr>
					</xsl:if>
					<xsl:if test="count(m1:name) &gt; 0">
						<tr>
							<td class="label"><blockquote>Name of the Feeder Fund</blockquote></td>
							<td>
								<div class="fakeBox3">	
									<xsl:value-of select="m1:name" />
								</div>
							</td>					
						</tr>
					</xsl:if>
					<xsl:if test="$masterFundFlagYesNo = 'Y'">
						<tr>
							<td class="label">b. Securities Act file number of each Feeder Fund.</td>
							<td>
								<div class="fakeBox2">	
									<xsl:value-of select="string(m1:fileNumber)" />
								</div>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count(m1:cik) &gt; 0">
						<tr>
							<td class="label">c. EDGAR series identifier of each Feeder Fund.</td>
							<td>
								<div class="fakeBox2">	
									<xsl:value-of select="m1:seriesId" />
								</div>
							</td>										
						</tr>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
			<tr>
				<td class="label"><b>Item A.9</b> Is this series primarily used to fund insurance company separate accounts?</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:seriesFundInsuCmpnySepAccntFlag) = 'Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:seriesFundInsuCmpnySepAccntFlag) = 'N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>				
			</tr>
			<tr>
				<td class="label"><b>Item A.10</b> Category. Indicate the category that identifies the money market fund from among the following:</td>
				<td>
					<xsl:choose>
						<xsl:when 
							test="m1:seriesLevelInfo/m1:moneyMarketFundCategory = 'Treasury'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>Treasury <br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Government/Agency <br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Exempt Government <br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Prime <br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Single State <br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Other Tax Exempt
						</xsl:when>
						<xsl:when 
							test="m1:seriesLevelInfo/m1:moneyMarketFundCategory = 'Government/Agency'">
							<img src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>Treasury <br/>
							<img src="Images/radio-checked.jpg"  alt="radio button checked"/>Government/Agency	<br/>
							<img src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>Exempt Government	<br/>
							<img src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>Prime	<br/>
							<img src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>Single State	<br/>
							<img src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>Other Tax Exempt
						</xsl:when>
						<xsl:when 
							test="m1:seriesLevelInfo/m1:moneyMarketFundCategory = 'Exempt Government'">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Treasury 	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Government/Agency	<br/>
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>Exempt Government	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Prime	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Single State	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Other Tax Exempt
						</xsl:when>
						<xsl:when 
							test="m1:seriesLevelInfo/m1:moneyMarketFundCategory = 'Prime'">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Treasury	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Government/Agency	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Exempt Government	<br/>
							<img src="Images/radio-checked.jpg" alt="radio button checked" />Prime	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Single State	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Other Tax Exempt
						</xsl:when>						
						<xsl:when 
							test="m1:seriesLevelInfo/m1:moneyMarketFundCategory = 'Single State'">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Treasury	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Government/Agency<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Exempt Government	<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Prime<br/>
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>Single State<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Other Tax Exempt
						</xsl:when>
						<xsl:when 
							test="m1:seriesLevelInfo/m1:moneyMarketFundCategory = 'Other Tax Exempt'">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Treasury<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Government/Agency<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Exempt Government<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Prime<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Single State<br/>
							<img src="Images/radio-checked.jpg"   alt="radio button checked"/>Other Tax Exempt
						</xsl:when>						
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Treasury<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Government/Agency<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Exempt Government<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Prime<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Single State<br/>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Other Tax Exempt						
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td class="label">a. Is this fund an exempt retail fund as defined in 270.2a-7(a)(25)?</td>
				<td>
					<xsl:choose>
						<xsl:when 
							test="string(m1:seriesLevelInfo/m1:fundExemptRetailFlag) = 'Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when 
							test="string(m1:seriesLevelInfo/m1:fundExemptRetailFlag) = 'N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			<tr >
				<td class="label"><b>Item A.11</b> Dollar-weighted average portfolio maturity ("WAM" as defined in rule 2a-7(d)(1)(ii)).</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:averagePortfolioMaturity)" />
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item A.12</b> Dollar-weighted average life maturity ("WAL" as defined in rule 2a-7(d)(1)(iii)). 
					Calculate WAL without reference to the exceptions in rule 2a-7(d) regarding interest rate readjustments.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:averageLifeMaturity)" />
					</div>										
				</td>
			</tr>
			<tr> 
				<td class="label">
					<b>Item A.13</b> Liquidity. Provide the following, as of the close of business on each Friday during the month reported (if the reporting date falls on a holiday or other day on which the fund does not calculate the daily or weekly liquidity, provide the value as of the close of business on the date in that week last calculated):
				</td>
				<td>
				</td>
			</tr>
		</table>
		
		<h4><em>a. Total Value of Daily Liquid Assets to the nearest cent:</em></h4>
		<table>
			<tr>
				<td class="label">i. Friday, week 1:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek1) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek1, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">ii. Friday, week 2:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek2) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek2, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iii. Friday, week 3:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek3) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek3, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iv. Friday, week 4:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek4) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek4, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">v. Friday, week 5 (if applicable):</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek5) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayWeek5, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
		</table>
		
		<h4><em>b. Total Value of Weekly Liquid Assets (including Daily Liquid Assets) to the nearest cent:</em></h4>
		<table>
			<tr>
				<td class="label">i. Friday, week 1:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek1) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek1, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">ii. Friday, week 2:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek2) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek2, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iii. Friday, week 3:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek3) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek3, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iv. Friday, week 4:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek4) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek4, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">v. Friday, week 5 (if applicable):</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek5) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek5, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
		</table>
		
		<h4><em>c. Percentage of Total Assets invested in Daily Liquid Assets:</em></h4>
		<table>
			<tr>
				<td class="label">i. Friday, week 1:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek1) &gt;= 0">
							<xsl:variable name="dailyWeek1" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek1 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek1 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">ii. Friday, week 2:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek2) &gt;= 0">
							<xsl:variable name="dailyWeek2" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek2 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek2 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iii. Friday, week 3:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek3) &gt;= 0">
							<xsl:variable name="dailyWeek3" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek3 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek3 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iv. Friday, week 4:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek4) &gt;= 0">
							<xsl:variable name="dailyWeek4" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek4 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek4 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">v. Friday, week 5 (if applicable):</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek5) &gt;= 0">
							<xsl:variable name="dailyWeek5" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayWeek5 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek5 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
		</table>
		
		<h4><em>d. Percentage of Total Assets invested in Weekly Liquid Assets (including Daily Liquid Assets):</em></h4>		
		<table>
			<tr>
				<td class="label">i. Friday, week 1:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek1) &gt;= 0">
							<xsl:variable name="weeklyWeek1" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek1 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek1 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">ii. Friday, week 2:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek2) &gt;= 0">
							<xsl:variable name="weeklyWeek2" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek2 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek2 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iii. Friday, week 3:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek3) &gt;= 0">
							<xsl:variable name="weeklyWeek3" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek3 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek3 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">iv. Friday, week 4:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek4) &gt;= 0">
							<xsl:variable name="weeklyWeek4" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek4 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek4 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">v. Friday, week 5 (if applicable):</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek5) &gt;= 0">
							<xsl:variable name="weeklyWeek5" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek5 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek5 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
		</table>
		
		<table>
			<tr>
				<td class="label">
					<b>Item A.14</b> Provide the following, to the nearest cent:
				</td>
				<td>
				</td>
			</tr>
			
			<tr>
				<td class="label">a. Cash. (See General Instructions E.)</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:cash) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:cash, "$###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			
			<tr>
				<td class="label">
					b. Total Value of portfolio securities. (See General Instructions E.)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValuePortfolioSecurities) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValuePortfolioSecurities, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>i. If any portfolio securities are valued using amortized cost, the total value of the portfolio securities valued at amortized cost.</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:amortizedCostPortfolioSecurities) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:amortizedCostPortfolioSecurities, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">c. Total Value of other assets (excluding amounts provided in A.14.a-c.)</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueOtherAssets) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueOtherAssets, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item A.15</b> Total value of liabilities, to the nearest cent.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueLiabilities) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueLiabilities, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			
			<tr >
				<td class="label"><b>Item A.16</b> Net assets of the series, to the nearest cent.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetOfSeries) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetOfSeries, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>									
				</td>
			</tr>		
		
			<tr >
				<td class="label"><b>Item A.17</b> Number of shares outstanding, to the nearest hundredth.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:numberOfSharesOutstanding) &gt; 0">
							$<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:numberOfSharesOutstanding ,  "ddd,ddd,ddd,dd0.00dd", "percentage")' />
						</xsl:if>
					</div>									
				</td>
			</tr>	

			<tr >
				<td class="label"><b>Item A.18</b> If the fund seeks to maintain a stable price per share, state the price the fund seeks to maintain.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:stablePricePerShare) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:stablePricePerShare, "$#,##0.0000")' />
						</xsl:if>	
					</div>									
				</td>
			</tr>

			<tr>
				<td class="label"><b>Item A.19</b> 7-day gross yield.  Based on the 7 days ended on the last day of the prior month, calculate the fund's yield by determining the net change, exclusive of capital changes and income other than investment income, in the value of a hypothetical pre-existing account having a balance of one share at the beginning of the period and dividing the difference by the value of the account at the beginning of the base period to obtain the base period return, and then multiplying the base period return by (365/7) with the resulting yield figure carried to the nearest hundredth of one percent.  The 7-day gross yield should not reflect a deduction of shareholders fees and fund operating expenses.  For master funds and feeder funds, report the 7-day gross yield at the master-fund level.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:sevenDayGrossYield) &gt;= -1.9999">
							<xsl:variable name="sevenDayGrossYield" select='format-number(m1:seriesLevelInfo/m1:sevenDayGrossYield , "0.0000", "percentage")'/>
							<xsl:value-of select='format-number(100 * $sevenDayGrossYield ,  "dd0.00", "percentage")' />%							
						</xsl:if>
					</div>									
				</td>
			</tr>		
			<tr>
				<td class="label">
					<b>Item A.20</b> Net asset value per share.  Provide the net asset value per share, calculated using available market quotations (or an appropriate substitute that reflects current market conditions) rounded to the fourth decimal place in the case of a fund with a $1.0000 share price (or an equivalent level of accuracy for funds with a different share price), as of the close of business on each Friday during the month reported (if the reporting date falls on a holiday or other day on which the fund does not calculate the net asset value per share, provide the value as of the close of business on the date in that week last calculated):
				</td>
				<td>
				</td>
			</tr>
			<tr>
				<td class="label">i. Friday, week 1:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek1) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek1, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">ii. Friday, week 2:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek2) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek2, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">iii. Friday, week 3:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek3) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek3, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">iv. Friday, week 4:</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek4) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek4, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">v. Friday, week 5 (if applicable):</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek5) &gt; -10000">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek5, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
		</table>

		<h3>Part B: Class-Level Information about the Fund</h3>
		<h4>For each Class of the Series (regardless of the number of shares outstanding in the Class), disclose the following:</h4>
		<xsl:for-each select="m1:classLevelInfo">
			<table>
				<tr>
					<td class="label"><b>Item B.1</b> EDGAR Class identifier.</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:classesId" />
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label"><b>Item B.2</b> Minimum initial investment.</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:minInitialInvestment) &gt; 0">
								<xsl:value-of select='format-number(m1:minInitialInvestment, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label"><b>Item B.3</b> Net assets of the Class, to the nearest cent.</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetsOfClass) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetsOfClass, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item B.4</b> Number of shares outstanding, to the nearest hundredth.
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:numberOfSharesOutstanding) &gt; 0">
								$<xsl:value-of select='format-number(m1:numberOfSharesOutstanding ,  "ddd,ddd,ddd,dd0.00dd", "percentage")' />
							</xsl:if>
						</div>					
					</td>
				</tr>	
				<tr>
					<td class="label">
						<b>Item B.5</b> Net asset value per share. Provide the net asset value per share, calculated using available market quotations (or an appropriate substitute that reflects current market conditions), rounded to the fourth decimal place in the case of a fund with a $1.0000 share price (or an equivalent level of accuracy for funds with a different share price), as of the close of business on each Friday during the month reported (if the reporting date falls on a holiday or other day on which the fund does not calculate the net asset value per share, provide the value as of the close of business on the date in that week last calculated):
					</td>
					<td>
					</td>
				</tr>
				<tr>
					<td class="label">i. Friday, week 1:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek1) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek1, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">ii. Friday, week 2:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek2) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek2, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">iii. Friday, week 3:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek3) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek3, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">iv. Friday, week 4:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek4) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek4, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">v. Friday, week 5 (if applicable):</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:netAssetPerShare/ns3:fridayWeek5) &gt; -10000"> <!-- DCS says that it can be a negative -->
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek5, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item B.6</b> Net shareholder flow.  Provide the aggregate weekly gross subscriptions 
						(including dividend reinvestments) and gross redemptions, rounded to the nearest cent, 
						as of the close of business on each Friday during the month reported (if the reporting 
						date falls on a holiday or other day on which the fund does not calculate the gross 
						subscriptions or gross redemptions, provide the value as of the close of business on 
						the date in that week last calculated):
					</td>
					<td></td>
				</tr>
			</table>
			
			<h4><em>a. Friday, week 1:</em></h4>
			<table>
				<tr>
					<td class="label">i. Weekly gross subscriptions (including dividend reinvestments):</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek1/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek1/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
				<tr>
					<td class="label">ii. Weekly gross redemptions:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek1/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek1/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
			</table>
			
			<h4><em>b. Friday, week 2:</em></h4>
			<table>
				<tr>
					<td class="label">i. Weekly gross subscriptions (including dividend reinvestments):</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek2/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek2/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">ii. Weekly gross redemptions:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek2/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek2/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
			</table>
			
			<h4><em>c. Friday, week 3:</em></h4>
			<table>
				<tr>
					<td class="label">i. Weekly gross subscriptions (including dividend reinvestments):</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek3/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek3/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">ii. Weekly gross redemptions:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek3/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek3/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>			
			</table>
			
			<h4><em>d. Friday, week 4:</em></h4>
			<table>
				<tr>
					<td class="label">i. Weekly gross subscriptions (including dividend reinvestments):</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek4/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek4/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">ii. Weekly gross redemptions:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek4/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek4/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>	
			</table>

			<h4><em>e. Friday, week 5:</em></h4>
			<table>			
				<tr>
					<td class="label">i. Weekly gross subscriptions (including dividend reinvestments):</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:fridayWeek5/m1:weeklyGrossSubscriptions) &gt;= 0">
								$<xsl:value-of select='format-number(m1:fridayWeek5/m1:weeklyGrossSubscriptions ,  "ddd,ddd,ddd,dd0.00", "percentage")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">ii. Weekly gross redemptions:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:fridayWeek5/m1:weeklyGrossRedemptions) &gt;= 0">
								$<xsl:value-of select='format-number(m1:fridayWeek5/m1:weeklyGrossRedemptions ,  "ddd,ddd,ddd,dd0.00", "percentage")' />
							</xsl:if>
						</div>				
					</td>
				</tr>	
			</table>
			
			<h4><em>f. Total for the month reported:</em></h4>
			<table>			
				<tr>
					<td class="label">i. Monthly gross subscriptions (including dividend reinvestments):</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:totalForTheMonthReported/m1:weeklyGrossSubscriptions) &gt; 0">	
								<xsl:value-of select='format-number(m1:totalForTheMonthReported/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">ii. Monthly gross redemptions:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:totalForTheMonthReported/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:totalForTheMonthReported/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
			</table>
			<table>
				<tr>
					<td class="label"><b>Item B.7</b> 7-day net yield, as calculated under Item 26(a)(1) of Form N-1A (§ 274.11A of this chapter).</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:sevenDayNetYield) &gt;= -1.9999">
								<xsl:variable name="sevenDayNetYield" select='format-number(m1:sevenDayNetYield, "0.0000", "percentage")' />
								<xsl:value-of select='format-number(100 * $sevenDayNetYield ,  "dd0.00", "percentage")' />%
							</xsl:if>
						</div>						
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item B.8</b> During the reporting period, did any Person pay for, or waive all or part of the fund's operating expenses or management fees? If Yes, answer Item B.8.a.
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:personPayForFundFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:personPayForFundFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>

				<xsl:if test="string(m1:personPayForFundFlag) = 'Y'">
					<tr>
						<td class="label">a. Provide the name of the Person and describe the nature and amount of the expense payment or fee waiver, or both (reported in dollars).</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="m1:nameOfPersonDescExpensePay" />
							</div>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:for-each>
		
		<xsl:for-each select="m1:scheduleOfPortfolioSecuritiesInfo">
			<h3>Part C: Schedule of Portfolio Securities. For each security held by the money market fund, disclose the following:</h3>
			<table>
				<tr>
					<td class="label"><b>Item C.1</b> The name of the issuer.</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="m1:nameOfIssuer" />
						</div>					
					</td>
				</tr>
				<tr >
					<td class="label"><b>Item C.2</b> The title of the issue (including coupon, if applicable).</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="m1:titleOfIssuer" />
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label"><b>Item C.3</b> The CUSIP.</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:CUSIPMember" />
						</div>
					</td>
				</tr>	
				
				<tr>
					<td class="label"><b>Item C.4</b> The LEI (if available). (See General Instruction E.)</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:LEIID" />
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item C.5</b> 
						Other identifier. In addition to CUSIP and LEI, provide at least one of the
						following other identifiers, if available:
					</td>
					<td>
					</td>
				</tr>
				<tr>
					<td class="label">a. The ISIN;</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:ISINId" />
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">b. The CIK; or</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:cik" />
						</div>
					</td>
				</tr>

				<tr>
					<td class="label">c. Other unique identifier.</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:otherUniqueId" />
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label"><b>Item C.6</b> The category of investment. Indicate the category that most closely identifies the instrument from among the following:
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'U.S. Treasury Debt'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> U.S. Treasury Debt<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'U.S. Government Agency Debt'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> U.S. Government Agency Debt<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Non-U.S. Sovereign, Sub-Sovereign and Supra-National debt'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Non-U.S. Sovereign, Sub-Sovereign and Supra-National debt<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Certificate of Deposit'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Certificate of Deposit<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Non-Negotiable Time Deposit'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Non-Negotiable Time Deposit<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Variable Rate Demand Note'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Variable Rate Demand Note<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Other Municipal Security'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Other Municipal Security<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Asset Backed Commercial Paper'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Asset Backed Commercial Paper<br/>

						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Other Asset Backed Securities'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Other Asset Backed Securities<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'U.S. Treasury Repurchase Agreement, if collateralized only by U.S. Treasuries (including Strips) and cash'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> U.S. Treasury Repurchase Agreement, if collateralized only by U.S. Treasuries (including Strips) and cash<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'U.S. Government Agency Repurchase Agreement, collateralized only by U.S. Government Agency securities, U.S. Treasuries, and cash'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> U.S. Government Agency Repurchase Agreement, collateralized only by U.S. Government Agency securities, U.S. Treasuries, and cash<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Other Repurchase Agreement, if any collateral falls outside Treasury, Government Agency and cash'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Other Repurchase Agreement, if any collateral falls outside Treasury, Government Agency and cash<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Insurance Company Funding Agreement'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Insurance Company Funding Agreement<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Investment Company'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Investment Company<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Financial Company Commercial Paper'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Financial Company Commercial Paper<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Non-Financial Company Commercial Paper'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Non-Financial Company Commercial Paper<br/>

						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Tender Option Bond'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Tender Option Bond<br/>
						
						<xsl:choose>
							<xsl:when test="string(m1:investmentCategory) = 'Other Instrument'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>&#160;</xsl:text> Other Instrument<br/>
					</td>					
				</tr>
				<xsl:if test="count(m1:briefDescription) &gt; 0">
					<tr>
						<td class="label">Brief Description</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="m1:briefDescription" />
							</div>						
						</td>					
					</tr>
				</xsl:if>
				<tr>
					<td class="label"><b>Item C.7</b> If the security is a repurchase agreement, is the fund treating the acquisition of the repurchase agreement as the acquisition of the underlying securities (<i>i.e.</i>, collateral) for purposes of portfolio diversification under rule 2a-7? 
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:fundAcqstnUndrlyngSecurityFlag)='Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="string(m1:fundAcqstnUndrlyngSecurityFlag)='N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No
					</td>					
				</tr>				
				<tr>
					<td class="label">
						<b>Item C.8</b> For all repurchase agreements, specify whether the repurchase agreement is "open" 
						(<i>i.e.</i>, the repurchase agreement has no specified end date and, by its terms, will be extended 
						or "rolled" each business day (or at another specified period) unless the investor chooses to terminate it), 
						and describe the securities subject to the repurchase agreement (<i>i.e.</i>, collateral).
					</td>
					<td>
					</td>
				</tr>
				<xsl:for-each select="m1:repurchaseAgreement">
					<xsl:if test="count(m1:repurchaseAgreementOpenFlag) &gt; 0">
						<tr>
							<td class="label">a. Is the repurchase agreement "open"? </td>
							<td>
								<xsl:choose>
									<xsl:when test="string(m1:repurchaseAgreementOpenFlag)='Y'">	
										<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
									</xsl:otherwise>
								</xsl:choose> &#160;
								<xsl:choose>
									<xsl:when test="string(m1:repurchaseAgreementOpenFlag)='N'">	
										<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No 
									</xsl:otherwise>
								</xsl:choose>											
							</td>					
						</tr>
					</xsl:if>
					<xsl:for-each select="m1:collateralIssuers">
						<xsl:if test="count(m1:nameOfCollateralIssuer) &gt; 0">
							<tr>
								<td class="label">b. The name of the collateral issuer.
								</td>
								<td>						
									<div class="fakeBox3">
										<xsl:value-of select="m1:nameOfCollateralIssuer" />
									</div>	
								</td>
							</tr>	
						</xsl:if>
						<xsl:if test="count(m1:LEIID) &gt; 0">
							<tr>
								<td class="label">c. LEI (if available).</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:LEIID" />
									</div>	
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="count(m1:maturityDate/m1:date) &gt; 0 or count(m1:maturityDate/m1:dateRange) &gt; 0">
							<tr>
								<td class="label">d. Maturity date.</td>
								<td>
									<div class="fakeBox2">
										<xsl:if test="count(m1:maturityDate/m1:date) &gt; 0">
											<xsl:value-of select="m1:maturityDate/m1:date" />
										</xsl:if>
										<xsl:if test="count(m1:maturityDate/m1:dateRange) &gt; 0">
											<xsl:value-of select="m1:maturityDate/m1:dateRange/ns3:from" /> 
											&#160;<font color="black">-</font>&#160;
											<xsl:value-of select="m1:maturityDate/m1:dateRange/ns3:to" />
										</xsl:if>
									</div>						
								</td>
							</tr>	
						</xsl:if>
						<xsl:if test="count(m1:couponOrYield) &gt; 0">
							<tr>
								<td class="label">e.  Coupon or yield.</td>
								<td>
									<div class="fakeBox2" style="font-size:0.85em">
										<xsl:value-of select="m1:couponOrYield" />
									</div>						
								</td>
							</tr>	
						</xsl:if>
						<xsl:if test="count(m1:principalAmountToTheNearestCent) &gt; 0 and string(m1:principalAmountToTheNearestCent) &gt;= 0">
							<tr>
								<td class="label">f. The principal amount, to the nearest cent.</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select='format-number(m1:principalAmountToTheNearestCent, "$###,###,###,##0.00")' />
									</div>						
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="count(m1:valueOfCollateralToTheNearestCent) &gt; 0 and string(m1:valueOfCollateralToTheNearestCent) &gt;= 0">
							<tr>
								<td class="label">g. Value of collateral, to the nearest cent.</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select='format-number(m1:valueOfCollateralToTheNearestCent, "$###,###,###,##0.00")' />
									</div>						
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="count(m1:ctgryInvestmentsRprsntsCollateral) &gt; 0">
							<tr>
								<td class="label">h. The category of investments that most closely represents the collateral, selected from among the following:
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Asset-Backed Securities'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Asset-Backed Securities<br/>
									
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Agency Collateralized Mortgage Obligation'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Agency Collateralized Mortgage Obligations<br/>
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Agency Debentures and Agency Strips'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Agency Debentures and Agency Strips<br/>			
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Agency Mortgage-Backed Securities'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Agency Mortgage-Backed Securities<br/>	
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Private Label Collateralized Mortgage Obligations'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Private Label Collateralized Mortgage Obligations<br/>	
									
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Corporate Debt Securities'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Corporate Debt Securities<br/>
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Equities'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Equities<br/>
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Money Market'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Money Market<br/>									
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'U.S. Treasuries (including strips)'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> U.S. Treasuries (including strips)<br/>	
									<xsl:choose>
										<xsl:when test="m1:ctgryInvestmentsRprsntsCollateral = 'Other Instrument'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose><xsl:text>&#160;</xsl:text> Other Instrument  <br/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="count(m1:otherInstrumentBriefDesc) &gt; 0">
							<tr>
								<td class="label">If Other Instrument, include a brief description, including, if applicable, whether it is a collateralized debt obligation, municipal debt, whole loan, or international debt.	
								</td>
								<td>
									<div class="fakeBox3">
										<xsl:value-of select="m1:otherInstrumentBriefDesc" />
									</div>						
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>					
				</xsl:for-each>
				<tr>
					<td class="label">If multiple securities of an issuer are subject to the 
					repurchase agreement, the securities may be aggregated, in which case disclose: (a) the total principal amount and value and (b) the range of maturity dates and interest rates.</td>
					<td></td>
				</tr>
				
				<tr>
					<td class="label">
						<b>Item C.9</b> Rating. Indicate whether the security is a rated First Tier Security, rated Second Tier Security, an Unrated Security, or no longer an Eligible Security.
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="m1:securityRated ='First Tier Security'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose><xsl:text>&#160;</xsl:text>First Tier Security<br/>	
						
						<xsl:choose>
							<xsl:when test="m1:securityRated ='Rated Second Tier Security'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose><xsl:text>&#160;</xsl:text>Rated Second Tier Security<br/>	
						
						<xsl:choose>
							<xsl:when test="m1:securityRated ='Unrated Security'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose><xsl:text>&#160;</xsl:text>Unrated Security<br/>	
						
						<xsl:choose>
							<xsl:when test="m1:securityRated ='No Longer an Eligible Security'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose><xsl:text>&#160;</xsl:text>No Longer an Eligible Security<br/>					
					</td>
				</tr>	
				<xsl:for-each select="m1:designatedNrsro">
					<tr>
						<td class="label"><b>Item C.10</b> Name of each Designated NRSRO.
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="m1:nameOfDesignatedNRSRO" />
							</div>							
						</td>
					</tr>
					<tr>
						<td class="label">
							a.  For each Designated NRSRO, disclose the credit rating given by the Designated NRSRO. 
							If the instrument and its issuer are not rated by the Designated NRSRO, indicate "NR."
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:if test="count(m1:creditRatingDesignatedNRSRO) &gt; 0">
									<xsl:value-of select="m1:creditRatingDesignatedNRSRO" />
								</xsl:if>
							</div>
						</td>
					</tr>			
				</xsl:for-each>
				<tr >
					<td class="label">
						<b>Item C.11</b> The maturity date determined by taking into account the maturity shortening provisions of rule 2a-7(i) (i.e., the maturity date used to calculate WAM under rule 2a-7(d)(1)(ii)).
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:investmentMaturityDateWAM" />
						</div>							
					</td>
				</tr>				
				<tr >
					<td class="label">
						<b>Item C.12</b> The maturity date determined without reference to the exceptions in rule 2a-7(i) regarding interest rate readjustments (i.e., the maturity date used to calculate WAL under rule 2a-7(d)(1)(iii)).
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:investmentMaturityDateWAL" />
						</div>							
					</td>
				</tr>				
				<tr >
					<td class="label">
						<b>Item C.13</b> The maturity date determined without reference to the maturity shortening provisions of rule 2a-7(i) (<i>i.e.</i>, the
						ultimate legal maturity date on which, in accordance with the terms of the security without regard to any interest rate readjustment 
						or demand feature, the principal amount must unconditionally be paid).
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:finalLegalInvestmentMaturityDate" />
						</div>							
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item C.14</b> Does the security have a Demand Feature on which the fund is 
						relying to determine the quality, maturity or liquidity of the security? If Yes, answer Items C.14.a - 14.f. Where applicable, provide the information 
					required in Items C.14b - 14.f in the order that each Demand Feature issuer was reported in Item C.14.a 
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:securityDemandFeatureFlag)='Y'">	
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:securityDemandFeatureFlag)='N'">	
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>									
					</td>						
				</tr>
			
			</table>	
			<xsl:if test="string(m1:securityDemandFeatureFlag) ='Y'">
				<xsl:for-each select="m1:demandFeature">
					<table>
						<tr>
							<td class="label">a. The identity of the Demand Feature issuer(s).</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="m1:identityOfDemandFeatureIssuer" />
								</div>							
							</td>
						</tr>		

						<xsl:for-each select="m1:designatedNRSRODemandFeature">
							<tr>
								<td class="label">b. Designated NRSRO(s) for the Demand Feature(s) or provider(s) of the Demand Feature(s).</td>
								<td>
									<div class="fakeBox3">
										<xsl:value-of select="m1:nameOfDesignatedNRSRO" />
									</div>							
								</td>
							</tr>	
							<tr>
								<td class="label">c. For each Designated NRSRO, disclose the credit rating given by the 
								Designated NRSRO. If there is no rating given by the Designated NRSRO, indicate "NR."</td>
								<td>
									<div class="fakeBox2">
										<xsl:if test="count(m1:creditRatingDesignatedNRSRO) &gt; 0">
											<xsl:value-of select="m1:creditRatingDesignatedNRSRO" />
										</xsl:if>
									</div>
								</td>
							</tr>
						</xsl:for-each>	
						<tr>
							<td class="label">d. The amount (i.e., percentage) of fractional support provided by each Demand Feature issuer.</td>
							<td>
								<div class="fakeBox2">
									<xsl:if test="string(m1:amountProvidedByDemandFeatureIssuer) &gt;= 0">
										<xsl:variable name="amountProvidedByDemandFeatureIssuer" select='format-number(m1:amountProvidedByDemandFeatureIssuer, "0.0000", "percentage")'/>
										<xsl:value-of select='format-number(100 * $amountProvidedByDemandFeatureIssuer ,  "dd0.00", "percentage")' />%
									</xsl:if>
								</div>									
							</td>
						</tr>
						<tr>
							<td class="label">e. The period remaining until the principal amount of the security may be recovered through the Demand Feature.</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="m1:remainingPeriodDemandFeature" />
								</div>									
							</td>
						</tr>	
						<tr>
							<td class="label">f. Is the demand feature conditional? </td>
							<td>
								<xsl:choose>
									<xsl:when test="string(m1:demandFeatureConditionalFlag)='Y'">	
										<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
									</xsl:otherwise>
								</xsl:choose> &#160;
								<xsl:choose>
									<xsl:when test="string(m1:demandFeatureConditionalFlag)='N'">	
										<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
									</xsl:otherwise>
								</xsl:choose>											
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:if>
			
			<table>
				<tr>
					<td class="label"><b>Item C.15</b> Does the security have a Guarantee (other than an unconditional letter of credit disclosed in item C.14 
					above) on which the fund is relying to determine the quality, maturity or liquidity of the security? If Yes, answer Items C.15.a - 15.d.  Where applicable, provide the information required in Item C.15.b - 15.d 
						in the order that each Guarantor was reported in Item C.15.a. </td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:securityGuaranteeFlag)='Y'">	
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:securityGuaranteeFlag)='N'">	
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>							
					</td>
				</tr>
	
			</table>
			
			<xsl:if test="string(m1:securityGuaranteeFlag) = 'Y'">
				<xsl:for-each select="m1:guarantor">
					<table>
						<tr>
							<td class="label">a. The identity of the Guarantor(s).</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="m1:identityOfTheGuarantor" />
								</div>							
							</td>
						</tr>
				
						<xsl:for-each select="m1:designatedNRSROGuarantor">
							<tr>
								<td class="label">b. Designated NRSRO(s) for the Guarantee(s) or Guarantor(s).</td>
								<td>
									<div class="fakeBox3">
										<xsl:value-of select="m1:nameOfDesignatedNRSRO" />
									</div>							
								</td>
							</tr>	
							<tr>
								<td class="label">c. For each Designated NRSRO, disclose the credit rating given by the 
								Designated NRSRO. If there is no rating given by the Designated NRSRO, indicate "NR."</td>
								<td>
									<div class="fakeBox2">
										<xsl:if test="count(m1:creditRatingDesignatedNRSRO) &gt; 0">
											<xsl:value-of select="m1:creditRatingDesignatedNRSRO" />
										</xsl:if>
									</div>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td class="label">d. The amount (<i>i.e.</i>, percentage) of fractional support provided by each Guarantor.</td>
							<td>
								<div class="fakeBox2">
									<xsl:if test="string(m1:amountProvidedByGuarantor) &gt;= 0">
										<xsl:variable name="amountProvidedByGuarantor" select='format-number(m1:amountProvidedByGuarantor , "0.0000", "percentage")'/>
										<xsl:value-of select='format-number(100 * $amountProvidedByGuarantor ,  "dd0.00", "percentage")' />%
									</xsl:if>
								</div>									
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:if>
			
			<table>
				<tr>
					<td class="label">
						<b>Item C.16</b> Does the security have any enhancements, other than those identified in Items C.14 and C.15 
						above, on which the fund is relying to determine the quality, maturity or liquidity of the security? If Yes, answer Items C.16.a - 16.e.  Where applicable, provide the information required in 
						Items C.16.b - 16.e in the order that each enhancement provider was reported in Item C.16.a. 
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:securityEnhancementsFlag)='Y'">	
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:securityEnhancementsFlag)='N'">	
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			
			</table>
			<xsl:if test="string(m1:securityEnhancementsFlag)='Y'">
				<xsl:for-each select="m1:enhancementProvider">
					<table  >
						<tr>
							<td class="label">a. The identity of the enhancement provider(s).</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="m1:identityOfTheEnhancementProvider" />
								</div>							
							</td>
						</tr>
						<tr>
							<td class="label">b. The type of enhancement(s).</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="m1:typeOfEnhancement" />
								</div>							
							</td>
						</tr>					
						<xsl:for-each select="m1:designatedNRSROEnhancement">
							<tr>
								<td class="label">c. Designated NRSRO(s) for the enhancement(s) or enhancement provider(s).</td>
								<td>
									<div class="fakeBox3">
										<xsl:value-of select="m1:nameOfDesignatedNRSRO" />
									</div>							
								</td>
							</tr>	
							<tr>
								<td class="label">d.  For each Designated NRSRO, disclose the credit rating given by the Designated NRSRO.  If there is no rating given by the Designated NRSRO, indicate "NR."</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:creditRatingDesignatedNRSRO" />
									</div>	
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td class="label">e. The amount (<i>i.e.</i>, percentage) of fractional support provided by each enhancement provider.</td>
							<td>
								<div class="fakeBox2">
									<xsl:if test="string(m1:amountProvidedByEnhancement) &gt;= 0">
										<xsl:variable name="amountProvidedByEnhancement" select='format-number(m1:amountProvidedByEnhancement, "0.0000", "percentage")'/>
										<xsl:value-of select='format-number(100 * $amountProvidedByEnhancement ,  "dd0.00", "percentage")' />%
									</xsl:if>
								</div>									
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:if>
			
			<table>
				<tr >
					<td class="label"><b>Item C.17</b> The yield of the security as of the reporting date.</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:yieldOfTheSecurityAsOfReportingDate) &gt;= 0">
								<xsl:variable name="yieldOfTheSecurityAsOfReportingDate" select='format-number(m1:yieldOfTheSecurityAsOfReportingDate, "0.0000", "percentage")'/>
								<xsl:value-of select='format-number(100 * $yieldOfTheSecurityAsOfReportingDate ,  "dd0.00", "percentage")' />%
							</xsl:if>
						</div>										
					</td>
				</tr>				
			</table>
			<table  >
				<tr>
					<td class="label"><b>Item C.18</b> The total Value of the fund's position in the 
					security, to the nearest cent:  (See General Instruction E.)</td>
					<td>
					</td>
				</tr>
			
				<tr>
					<td class="label">a. <i>Including</i> the value of any sponsor support:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:includingValueOfAnySponsorSupport) &gt; 0">
								<xsl:value-of select='format-number(m1:includingValueOfAnySponsorSupport, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>										
					</td>
				</tr>	
			
				<tr>
					<td class="label">b. <i>Excluding</i> the value of any sponsor support:</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:excludingValueOfAnySponsorSupport) &gt; 0">
								<xsl:value-of select='format-number(m1:excludingValueOfAnySponsorSupport, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>										
					</td>
				</tr>	
			</table>
			<table>
				<tr>
					<td class="label"><b>Item C.19</b> The percentage of the money market fund's net assets
					invested in the security, to the nearest hundredth of a percent.</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:percentageOfMoneyMarketFundNetAssets) &gt;= 0">
								<xsl:variable name="percentageOfMoneyMarketFundNetAssets" select='format-number(m1:percentageOfMoneyMarketFundNetAssets, "0.0000", "percentage")'/>
								<xsl:value-of select='format-number(100 * $percentageOfMoneyMarketFundNetAssets ,  "dd0.00", "percentage")' />%
							</xsl:if>
						</div>										
					</td>
				</tr>				
				
				<tr>
					<td class="label"><b>Item C.20</b> Is the security categorized at level 3 in the fair value hierarchy under U.S. Generally Accepted Accounting Principles (ASC 820, Fair Value Measurement)?</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:securityCategorizedAtLevel3Flag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:securityCategorizedAtLevel3Flag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>				
				
				<tr>
					<td class="label"><b>Item C.21</b> Is the security a Daily Liquid Asset?</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:dailyLiquidAssetSecurityFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:dailyLiquidAssetSecurityFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>
				
				<tr>
					<td class="label"><b>Item C.22</b> Is the security a Weekly Liquid Asset?  </td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:weeklyLiquidAssetSecurityFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:weeklyLiquidAssetSecurityFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>				
				
				<tr>
					<td class="label"><b>Item C.23</b> Is the security an Illiquid Security?</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:illiquidSecurityFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:illiquidSecurityFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>
				
				<tr>
					<td class="label"><b>Item C.24</b>
					Explanatory notes.  Disclose any other information that may be material to other disclosures related to the portfolio security.  If none, leave blank.</td>
					<td>
						<div class="fakeBox3">
							<xsl:if test="count(m1:explanatoryNotes) &gt; 0">
								<xsl:value-of select="m1:explanatoryNotes" />
							</xsl:if>
						</div>	
					</td>
				</tr>
			</table>
		</xsl:for-each>
		
		<h1>N-MFP: Signatures</h1>
		<h4>
			Pursuant to the requirements of the Investment Company Act of 1940, the registrant has 
			duly caused this report to be signed on its behalf by the undersigned hereunto duly authorized.
		</h4>
		<table>
			<tr>
				<td class="label">(Registrant)</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:signature/m1:registrant)" />
					</div>					
				</td>
			</tr>
			<tr>
				<td class="label">Date</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:signature/m1:signatureDate)" />
					</div>					
				</td>
			</tr>
			<tr>
				<td class="label">(Signature)*</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:signature/m1:signature)" />
					</div>					
				</td>
			</tr>
			<tr>
				<td class="label">Name of Signing Officer</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:signature/m1:nameOfSigningOfficer)" />
					</div>					
				</td>
			</tr>
			<tr>
				<td class="label">Title of Signing Officer</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:signature/m1:titleOfSigningOfficer)" />
					</div>					
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>

